/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.TimeZoneType;
import org.mule.metadata.api.model.impl.DefaultTimeZoneType;

public class TimeZoneTypeBuilder extends AbstractBuilder<TimeZoneType>
    implements TypeBuilder<TimeZoneType>, WithAnnotation<TimeZoneTypeBuilder> {

  protected TimeZoneTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public TimeZoneTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public TimeZoneTypeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  public TimeZoneTypeBuilder defaultValue(String defaultValue) {
    return with(new DefaultValueAnnotation(defaultValue));
  }

  public TimeZoneTypeBuilder enumOf(String... values) {
    return with(new EnumAnnotation<>(values));
  }

  public TimeZoneTypeBuilder pattern(String pattern) {
    return with(new RegexPatternAnnotation(pattern));
  }

  @Override
  public TimeZoneType build() {
    return new DefaultTimeZoneType(format, annotations);
  }

  public TimeZoneTypeBuilder boundary(Number minLength,
                                      Number maxLength) {
    return with(new LengthAnnotation(minLength, maxLength));
  }

  public TimeZoneTypeBuilder length(Integer length) {
    return with(new LengthAnnotation(length, length));
  }
}
