/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import static java.util.Collections.addAll;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.TypeParameterType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultTypeParameterType extends BaseMetadataType implements TypeParameterType {

  private final String name;
  private Object[] fieldValues;

  public DefaultTypeParameterType(String name, MetadataFormat metadataFormat,
                                  Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
    super(metadataFormat, annotations);
    this.name = name;
  }

  @Override
  public Object[] getFieldValues() {
    if (fieldValues == null) {
      fieldValues = createFieldValuesArray();
    }

    return fieldValues;
  }

  private Object[] createFieldValuesArray() {
    List<Object> fieldValues = new ArrayList<>();
    addAll(fieldValues, super.getFieldValues());
    addAll(fieldValues, name);
    return fieldValues.toArray(new Object[fieldValues.size()]);
  }

  @Override
  public String getName() {
    return name;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitTypeParameter(this);
  }
}
