/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

public class BaseTypeBuilder implements TypeBuilder<MetadataType>, SimpleTypeBuilder<MetadataType> {

  private MetadataFormat format;
  private Optional<TypeBuilder<?>> builder;


  public BaseTypeBuilder(MetadataFormat format) {

    this.format = format;
    this.builder = Optional.empty();
  }

  public BaseTypeBuilder withFormat(MetadataFormat format) {
    this.format = format;
    return this;
  }

  public ObjectTypeBuilder objectType() {
    final ObjectTypeBuilder metadataBuilder = new ObjectTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public ArrayTypeBuilder arrayType() {
    final ArrayTypeBuilder metadataBuilder = new ArrayTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public TypeParameterTypeBuilder typeParameter(String typeName) {
    TypeParameterTypeBuilder typeBuilder = new TypeParameterTypeBuilder(typeName, format);
    builder = Optional.of(typeBuilder);
    return typeBuilder;
  }


  public UnionTypeBuilder unionType() {
    final UnionTypeBuilder metadataBuilder = new UnionTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public TupleTypeBuilder tupleType() {
    final TupleTypeBuilder metadataBuilder = new TupleTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public FunctionTypeBuilder functionType() {
    FunctionTypeBuilder metadataBuilder = new FunctionTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  @Override
  public LocalDateTimeTypeBuilder localDateTimeType() {
    final LocalDateTimeTypeBuilder metadataBuilder = new LocalDateTimeTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  @Override
  public LocalTimeTypeBuilder localTimeType() {
    final LocalTimeTypeBuilder metadataBuilder = new LocalTimeTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  @Override
  public NothingTypeBuilder nothingType() {
    final NothingTypeBuilder metadataBuilder = new NothingTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  @Override
  public PeriodTypeBuilder periodType() {
    final PeriodTypeBuilder metadataBuilder = new PeriodTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  @Override
  public RegexTypeBuilder regexType() {
    final RegexTypeBuilder metadataBuilder = new RegexTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  @Override
  public TimeZoneTypeBuilder timeZoneType() {
    final TimeZoneTypeBuilder metadataBuilder = new TimeZoneTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public StringTypeBuilder stringType() {
    final StringTypeBuilder metadataBuilder = new StringTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public BooleanTypeBuilder booleanType() {
    final BooleanTypeBuilder metadataBuilder = new BooleanTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public NumberTypeBuilder numberType() {
    final NumberTypeBuilder metadataBuilder = new NumberTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public DateTimeBuilder dateTimeType() {
    final DateTimeBuilder metadataBuilder = new DateTimeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public DateTypeBuilder dateType() {
    final DateTypeBuilder metadataBuilder = new DateTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public TimeTypeBuilder timeType() {
    final TimeTypeBuilder metadataBuilder = new TimeTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public AnyTypeBuilder anyType() {
    final AnyTypeBuilder metadataBuilder = new AnyTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public BinaryTypeBuilder binaryType() {
    final BinaryTypeBuilder metadataBuilder = new BinaryTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public NullTypeBuilder nullType() {
    final NullTypeBuilder metadataBuilder = new NullTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public VoidTypeBuilder voidType() {
    final VoidTypeBuilder metadataBuilder = new VoidTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public IntersectionTypeBuilder intersectionType() {
    final IntersectionTypeBuilder metadataBuilder = new IntersectionTypeBuilder(format);
    builder = Optional.of(metadataBuilder);
    return metadataBuilder;
  }

  public MetadataType build() {
    return builder.orElseThrow(() -> new RuntimeException("No type was specified.")).build();
  }

  public static BaseTypeBuilder create(MetadataFormat format) {
    return new BaseTypeBuilder(format);
  }

}
