/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */

package org.mule.metadata.api.model;

/**
 * Represents a reference type an existing type. By using reference we can re-use Type and still modify its metadata, we can
 * support lazy loading and more
 *
 * @since 1.8.0
 */
public interface ReferenceType extends MetadataType {

  /**
   * The unique name of the type being referenced
   *
   * @return The name of the type being referenced
   */
  String name();

  /**
   * Returns the type being referenced
   *
   * @return The referenced type
   */
  MetadataType referenceType();

}


