/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api;

import org.mule.metadata.api.model.MetadataType;

import java.util.Optional;

/**
 * Type loader will load the definition of a given type identifier.
 */
public interface TypeLoader {

  /**
   * Returns the MetadataType of the specified identifier if found
   *
   * @param typeIdentifier The identifier name
   * @return The type if found
   */
  Optional<MetadataType> load(String typeIdentifier);

  /**
   * Returns the MetadataType of the specified identifier if found, optionally assigning specified type alias
   *
   * @param typeIdentifier The identifier name
   * @param typeAlias      The nullable type alias
   * @return The type if found
   */
  default Optional<MetadataType> load(String typeIdentifier, String typeAlias) {
    return load(typeIdentifier);
  }
}
