/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.annotation.NumberRangeAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.api.model.impl.DefaultNumberType;

public class NumberTypeBuilder extends AbstractBuilder<NumberType>
    implements TypeBuilder<NumberType>, WithAnnotation<NumberTypeBuilder> {

  protected NumberTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public NumberTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public NumberTypeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  public NumberTypeBuilder defaultValue(String defaultValue) {
    return with(new DefaultValueAnnotation(defaultValue));
  }


  public NumberTypeBuilder enumOf(Number... values) {
    return with(new EnumAnnotation<>(values));
  }

  @Override
  public NumberType build() {
    return new DefaultNumberType(format, annotations);
  }

  public NumberTypeBuilder range(Number from, Number to) {
    return with(new NumberRangeAnnotation(from, to));
  }

  public NumberTypeBuilder integer() {
    return with(new IntAnnotation());
  }
}
