/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ReferenceResolver;
import org.mule.metadata.api.model.ReferenceType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.Map;

public class DefaultReferenceType extends BaseMetadataType implements ReferenceType {

  private final ReferenceResolver resolver;
  private final String name;

  public DefaultReferenceType(ReferenceResolver resolver, String name, MetadataFormat metadataFormat,
                              Map<Class<? extends TypeAnnotation>, TypeAnnotation> annotations) {
    super(metadataFormat, annotations);
    this.resolver = resolver;
    this.name = name;
  }

  @Override
  public String name() {
    return name;
  }

  @Override
  public MetadataType referenceType() {
    return resolver.resolve();
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitReference(this);
  }
}
