/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.model.impl;

import static java.util.Collections.addAll;

import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultTupleType extends BaseMetadataType implements TupleType {

  private final List<MetadataType> types;
  private Object[] fieldValues;

  public DefaultTupleType(List<MetadataType> types, MetadataFormat metadataFormat,
                          Map<Class<? extends TypeAnnotation>, TypeAnnotation> extensions) {
    super(metadataFormat, extensions);
    this.types = types;
  }


  @Override
  public Object[] getFieldValues() {
    if (fieldValues == null) {
      fieldValues = createFieldValuesArray();
    }
    return fieldValues;
  }

  private Object[] createFieldValuesArray() {
    List<Object> fieldValues = new ArrayList<>();
    addAll(fieldValues, super.getFieldValues());
    addAll(fieldValues, types);
    return fieldValues.toArray(new Object[fieldValues.size()]);
  }

  @Override
  public List<MetadataType> getTypes() {
    return types;
  }

  @Override
  public void accept(MetadataTypeVisitor visitor) {
    visitor.visitTuple(this);
  }
}
