/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.api.builder;

import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.model.LocalDateTimeType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.impl.DefaultLocalDateTimeType;

public class LocalDateTimeTypeBuilder extends AbstractBuilder<LocalDateTimeType>
    implements TypeBuilder<LocalDateTimeType>, WithAnnotation<LocalDateTimeTypeBuilder> {

  protected LocalDateTimeTypeBuilder(MetadataFormat format) {
    super(format);
  }

  public LocalDateTimeTypeBuilder with(TypeAnnotation extension) {
    this.addExtension(extension);
    return this;
  }

  public LocalDateTimeTypeBuilder id(String typeIdentifier) {
    return with(new TypeIdAnnotation(typeIdentifier));
  }

  public LocalDateTimeTypeBuilder defaultValue(String defaultValue) {
    return with(new DefaultValueAnnotation(defaultValue));
  }


  @Override
  public LocalDateTimeType build() {
    return new DefaultLocalDateTimeType(format, annotations);
  }


}
