/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.catalog.internal;

import static org.mule.metadata.api.utils.MetadataTypeUtils.checkArgument;
import static org.mule.metadata.api.utils.MetadataTypeUtils.isNotNull;
import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.catalog.api.PrimitiveTypesTypeLoader;
import org.mule.metadata.catalog.api.TypeResolver;
import org.mule.metadata.catalog.api.TypeResolverException;

import java.util.Map;
import java.util.Optional;

public class DefaultTypeResolver implements TypeResolver {

  private final Map<String, TypeLoader> loaders;
  private final PrimitiveTypesTypeLoader primitiveTypesTypeLoader;

  public DefaultTypeResolver(Map<String, TypeLoader> loaders) {
    checkArgument(isNotNull(loaders), "loaders cannot be null.");
    this.loaders = loaders;
    this.primitiveTypesTypeLoader = new PrimitiveTypesTypeLoader();
  }

  @Override
  public Optional<MetadataType> resolveType(String reference) throws TypeResolverException {
    final String[] elements = reference.split(CATALOG_SEPARATOR);
    String catalog = elements[0];
    final String type = elements.length == 1 ? catalog : elements[1];
    return resolveType(catalog, type);
  }

  private Optional<MetadataType> resolveType(String catalog, String typeIdentifier) throws TypeResolverException {
    final Optional<MetadataType> optionalPrimitiveType = primitiveTypesTypeLoader.load(catalog);
    if (optionalPrimitiveType.isPresent()) {
      return optionalPrimitiveType;
    } else {
      final TypeLoader typeLoader = loaders.get(catalog);
      if (typeLoader == null) {
        throw new TypeResolverException(String.format("Catalog '%s' not found", catalog));
      }
      return typeLoader.load(typeIdentifier);
    }
  }
}
