/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.catalog.internal.model.loaders.example;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.catalog.internal.model.loaders.TypeLoaderFactory;
import org.mule.metadata.xml.ModelFactory;
import org.mule.metadata.xml.XmlTypeLoader;

import java.io.File;

public class XmlTypeLoaderFactory implements TypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return "application/xml";
  }

  @Override
  public String getLoaderFormat() {
    return "application/xml";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new XmlTypeLoader(ModelFactory.fromExample(file));
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new XmlTypeLoader(ModelFactory.fromExample(content));
  }
}
