/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.catalog.internal.model.loaders.example;

import org.mule.metadata.api.TypeLoader;
import org.mule.metadata.catalog.internal.model.loaders.TypeLoaderFactory;
import org.mule.metadata.json.JsonExampleTypeLoader;

import java.io.File;

public class JsonTypeLoaderFactory implements TypeLoaderFactory {

  @Override
  public String getTypeFormat() {
    return "application/json";
  }

  @Override
  public String getLoaderFormat() {
    return "application/json";
  }

  @Override
  public TypeLoader createTypeLoader(File file) {
    return new JsonExampleTypeLoader(file);
  }

  @Override
  public TypeLoader createTypeLoader(String content) {
    return new JsonExampleTypeLoader(content);
  }
}
