/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.catalog.internal.model.loaders;

import org.mule.metadata.api.TypeLoader;

import java.io.File;
import java.net.URI;

public interface TypeLoaderFactory {

  String getTypeFormat();

  String getLoaderFormat();

  TypeLoader createTypeLoader(File file);

  TypeLoader createTypeLoader(String content);

  default TypeLoader createTypeLoader(String content, URI uri) {
    return createTypeLoader(content);
  }
}
