/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.internal.handler;

import org.mule.metadata.api.builder.ArrayTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.metadata.ast.internal.ClassInformationAnnotationFactory;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;

/**
 * {@link TypeHandler} for {@link ArrayType array types}
 *
 * @since 1.1.0
 */
public class ArrayTypeHandler extends BaseTypeHandler {

  public ArrayTypeHandler(ProcessingEnvironment processingEnvironment) {
    super(processingEnvironment, Collection.class, Iterable.class, Iterator.class);
  }

  @Override
  public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor,
                               IntrospectionContext context) {
    if (astHelper.isAssignable(typeMirror, Collection.class, Iterable.class, Iterator.class)) {
      ArrayTypeBuilder arrayTypeBuilder = builder()
          .arrayType()
          .with(ClassInformationAnnotationFactory.fromTypeMirror(typeMirror, processingEnvironment));

      List<? extends TypeMirror> typeArguments = ((DeclaredType) typeMirror).getTypeArguments();
      if (typeArguments.isEmpty()) {
        arrayTypeBuilder.of(objectType.accept(visitor, context));
      } else {
        arrayTypeBuilder.of(typeArguments.get(0).accept(visitor, context));
      }
      return arrayTypeBuilder;
    }

    throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
  }
}
