/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.internal.handler;

import static org.mule.metadata.ast.internal.ClassInformationAnnotationFactory.fromTypeMirror;
import static org.mule.metadata.java.internal.handler.StringHandler.CHAR_LENGTH;

import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.metadata.ast.api.IntrospectionContext;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;

/**
 * {@link TypeHandler} for String represented types
 *
 * @since 1.1.0
 */
public class StringTypeHandler extends BaseTypeHandler {

  public StringTypeHandler(ProcessingEnvironment processingEnvironment) {
    super(processingEnvironment, Character.class, Class.class, String.class, CharSequence.class);
  }

  @Override
  public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor,
                               IntrospectionContext context) {
    if (astHelper.isAssignable(typeMirror, Character.class)) {
      return builder().stringType().with(fromTypeMirror(typeMirror, processingEnvironment))
          .with(new LengthAnnotation(CHAR_LENGTH, CHAR_LENGTH));
    }

    if (astHelper.isAssignable(typeMirror, Class.class)) {
      return builder().stringType().with(fromTypeMirror(typeMirror, processingEnvironment));
    }

    if (astHelper.isAssignable(typeMirror, String.class, CharSequence.class)) {
      return builder().stringType();
    }

    throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
  }
}
