/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.internal.handler;

import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.NumberType;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.internal.ClassInformationAnnotationFactory;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;

import java.math.BigInteger;

/**
 * {@link TypeHandler} for {@link NumberType number types}
 *
 * @since 1.1.0
 */
public class NumberTypeHandler extends BaseTypeHandler {

  public NumberTypeHandler(ProcessingEnvironment processingEnvironment) {
    super(processingEnvironment, Number.class, BigInteger.class, Integer.class, Long.class);
  }

  @Override
  public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor,
                               IntrospectionContext context) {
    if (astHelper.isAssignable(typeMirror, Number.class)) {
      NumberTypeBuilder numberTypeBuilder =
          builder().numberType().with(ClassInformationAnnotationFactory.fromTypeMirror(typeMirror, processingEnvironment));
      if (astHelper.isAssignable(typeMirror, BigInteger.class, Integer.class, Long.class)) {
        return numberTypeBuilder.integer();
      }
      return numberTypeBuilder;
    }

    throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
  }
}
