/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.internal.handler;

import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.BinaryType;
import org.mule.metadata.ast.internal.ClassInformationAnnotationFactory;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.metadata.ast.api.IntrospectionContext;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;

import java.io.InputStream;
import java.io.Reader;

/**
 * {@link TypeHandler} for {@link BinaryType binary types}
 *
 * @since 1.1.0
 */
public class BinaryTypeHandler extends BaseTypeHandler {

  public BinaryTypeHandler(ProcessingEnvironment processingEnvironment) {
    super(processingEnvironment, InputStream.class, Reader.class);
  }

  @Override
  public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor,
                               IntrospectionContext context) {
    if (astHelper.isAssignable(typeMirror, InputStream.class, Reader.class)) {
      return builder().binaryType().with(ClassInformationAnnotationFactory.fromTypeMirror(typeMirror, processingEnvironment));
    }

    throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
  }
}
