/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.api;

import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ObjectType;

import javax.lang.model.element.Element;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;

/**
 * Handler for fields of an {@link ObjectType}
 *
 * @since 1.1
 */
public interface ObjectFieldHandler {

  /**
   * Given an {@link Element}
   *
   * @param element           Type to introspect
   * @param objectTypeBuilder Current object that is being built
   * @param context           The current introspection context which contains the already processed
   * @param typeVisitor       {@link TypeVisitor} to convert a {@link TypeMirror} to a {@link TypeBuilder}
   */
  void handle(Element element, ObjectTypeBuilder objectTypeBuilder, IntrospectionContext context,
              TypeVisitor<TypeBuilder<?>, IntrospectionContext> typeVisitor);

}
