/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.internal.handler;

import static org.mule.metadata.api.utils.MetadataTypeUtils.checkArgument;

import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.api.TypeHandler;
import org.mule.metadata.ast.internal.ClassInformationAnnotationFactory;

import java.util.List;
import java.util.Map;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;

/**
 * {@link TypeHandler} for map types (a.k.a.: Open {@link ObjectType})
 *
 * @since 1.1.0
 */
public class MapTypeHandler extends BaseTypeHandler {

  public MapTypeHandler(ProcessingEnvironment processingEnvironment) {
    super(processingEnvironment, Map.class);
  }

  @Override
  public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor,
                               IntrospectionContext context) {
    checkArgument(typeMirror instanceof DeclaredType, "The given type should be a DeclaredType");
    DeclaredType declaredType = (DeclaredType) typeMirror;

    if (astHelper.isAssignable(typeMirror, Map.class)) {
      ObjectTypeBuilder objectTypeBuilder = builder()
          .objectType()
          .with(ClassInformationAnnotationFactory.fromTypeMirror(declaredType, processingEnvironment));

      List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
      if (typeArguments.isEmpty()) {
        objectTypeBuilder.openWith().anyType();
      } else {
        objectTypeBuilder.openWith(typeArguments.get(1).accept(visitor, context));
      }
      return objectTypeBuilder;
    }

    throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
  }
}
