/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import org.apache.commons.lang3.SystemUtils;
import org.mule.metadata.ast.internal.ASTHelperJDK9;
import org.mule.metadata.ast.internal.MuleLazyValue;

public class ASTHelper {
    private ProcessingEnvironment processingEnvironment;
    private Map<String, TypeMirror> primitiveTypeMirrors = new HashMap<String, TypeMirror>();
    private MuleLazyValue<ASTHelperJDK9> astHelperJDK9;

    public ASTHelper(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        this.primitiveTypeMirrors.put("int", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.INT));
        this.primitiveTypeMirrors.put("long", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.LONG));
        this.primitiveTypeMirrors.put("double", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.DOUBLE));
        this.primitiveTypeMirrors.put("float", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.FLOAT));
        this.primitiveTypeMirrors.put("boolean", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.BOOLEAN));
        this.primitiveTypeMirrors.put("char", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.CHAR));
        this.primitiveTypeMirrors.put("byte", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.BYTE));
        this.primitiveTypeMirrors.put("void", processingEnvironment.getTypeUtils().getNoType(TypeKind.VOID));
        this.primitiveTypeMirrors.put("short", processingEnvironment.getTypeUtils().getPrimitiveType(TypeKind.SHORT));
        this.astHelperJDK9 = new MuleLazyValue<Supplier<ASTHelperJDK9>>(() -> new ASTHelperJDK9(processingEnvironment));
    }

    public boolean isAssignable(ArrayType arrayType, Class ... classes) {
        for (Class aClass : classes) {
            if (!aClass.isArray() || !this.isAssignable(arrayType.getComponentType(), aClass.getComponentType())) continue;
            return true;
        }
        return false;
    }

    public boolean isAssignable(TypeMirror typeMirror, Class ... classes) {
        Types utils = this.processingEnvironment.getTypeUtils();
        for (Class aClass : classes) {
            if (!utils.isAssignable(utils.erasure(typeMirror), utils.erasure(this.getTypeMirror(aClass)))) continue;
            return true;
        }
        return false;
    }

    private TypeMirror getTypeMirror(Class aClass) {
        if (aClass.isPrimitive()) {
            return this.primitiveTypeMirrors.get(aClass.getCanonicalName());
        }
        if (this.shouldUseJavaModules()) {
            return this.astHelperJDK9.get().getTypeElement(aClass).asType();
        }
        Elements elementUtils = this.processingEnvironment.getElementUtils();
        return elementUtils.getTypeElement(aClass.getName()).asType();
    }

    public static String typeId(DeclaredType type) {
        return type.asElement().toString();
    }

    private boolean shouldUseJavaModules() {
        return !SystemUtils.IS_JAVA_1_8;
    }
}

