/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

class ASTHelperJDK9 {
    private Method getModuleElementMethod;
    private Method getTypeMethodElementMethod;
    private Method getModuleMethod;
    private Method getModuleNameMethod;
    private ProcessingEnvironment processingEnvironment;

    ASTHelperJDK9(ProcessingEnvironment processingEnvironment) {
        this.processingEnvironment = processingEnvironment;
        try {
            this.getModuleElementMethod = Elements.class.getMethod("getModuleElement", CharSequence.class);
            this.getTypeMethodElementMethod = Elements.class.getMethod("getTypeElement", Class.forName("javax.lang.model.element.ModuleElement"), CharSequence.class);
            this.getModuleMethod = Class.class.getMethod("getModule", new Class[0]);
            this.getModuleNameMethod = Class.forName("java.lang.Module").getMethod("getName", new Class[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("An unexpected error occurred trying to initialize this class, this is probably you are using a JDK 8 or previous.", e);
        }
    }

    TypeElement getTypeElement(Class aClass) {
        try {
            Elements elementUtils = this.processingEnvironment.getElementUtils();
            Object module = this.getModuleMethod.invoke((Object)aClass, new Object[0]);
            Object moduleName = this.getModuleNameMethod.invoke(module, new Object[0]);
            Object moduleElement = this.getModuleElementMethod.invoke((Object)elementUtils, moduleName);
            TypeElement typeElement = (TypeElement)this.getTypeMethodElementMethod.invoke((Object)elementUtils, moduleElement, aClass.getName());
            return typeElement;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException("Unexpected error occurred trying to Create TypeElement for class: " + aClass, e);
        }
    }
}

