/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.ast.internal.handler;

import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.ast.api.IntrospectionContext;
import org.mule.metadata.ast.internal.ClassInformationAnnotationFactory;
import org.mule.metadata.ast.internal.handler.BaseTypeHandler;

public class MapTypeHandler
extends BaseTypeHandler {
    public MapTypeHandler(ProcessingEnvironment processingEnvironment) {
        super(processingEnvironment, Map.class);
    }

    @Override
    public TypeBuilder<?> handle(TypeMirror typeMirror, TypeVisitor<TypeBuilder<?>, IntrospectionContext> visitor, IntrospectionContext context) {
        MetadataTypeUtils.checkArgument((boolean)(typeMirror instanceof DeclaredType), (String)"The given type should be a DeclaredType");
        DeclaredType declaredType = (DeclaredType)typeMirror;
        if (this.astHelper.isAssignable(typeMirror, Map.class)) {
            ObjectTypeBuilder objectTypeBuilder = this.builder().objectType().with((TypeAnnotation)ClassInformationAnnotationFactory.fromTypeMirror(declaredType, this.processingEnvironment));
            List<? extends TypeMirror> typeArguments = declaredType.getTypeArguments();
            if (typeArguments.isEmpty()) {
                objectTypeBuilder.openWith().anyType();
            } else {
                objectTypeBuilder.openWith(typeArguments.get(1).accept(visitor, context));
            }
            return objectTypeBuilder;
        }
        throw new IllegalArgumentException("The given TypeMirror is not handleable. " + typeMirror);
    }
}

