/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.ast.internal.handler;

import static org.mule.metadata.api.model.MetadataFormat.JAVA;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.ast.internal.ASTHelper;
import org.mule.metadata.ast.api.TypeHandler;

import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.type.TypeMirror;

/**
 * Base {@link TypeHandler} to reuse logic between handlers.
 *
 * @since 1.1.0
 */
public abstract class BaseTypeHandler implements TypeHandler {

  private final Class[] classes;
  public final ProcessingEnvironment processingEnvironment;
  final TypeMirror objectType;
  final ASTHelper astHelper;


  BaseTypeHandler(ProcessingEnvironment processingEnvironment, Class... classes) {
    this.processingEnvironment = processingEnvironment;
    this.classes = classes;
    this.objectType = processingEnvironment.getElementUtils().getTypeElement(Object.class.getCanonicalName()).asType();
    this.astHelper = new ASTHelper(processingEnvironment);
  }

  @Override
  public boolean handles(TypeMirror typeMirror) {
    return astHelper.isAssignable(typeMirror, classes);
  }

  public BaseTypeBuilder builder() {
    return BaseTypeBuilder.create(JAVA);
  }

}
