/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.internal.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.BinaryTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;

public class BinaryHandler extends BaseClassHandler {

  public BinaryHandler() {
    super(byte[].class, Byte[].class, byte.class, Byte.class,
          InputStream.class, Reader.class);
  }

  @Override
  public TypeBuilder<?> handleClass(Class<?> clazz,
                                    List<Type> genericTypes, TypeHandlerManager typeHandlerManager,
                                    ParsingContext context, BaseTypeBuilder typeBuilder) {
    final BinaryTypeBuilder binaryType = typeBuilder.binaryType();
    final String canonicalName = clazz.getCanonicalName();
    if (canonicalName != null) {
      binaryType.id(canonicalName);
    }
    return binaryType;
  }
}
