/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.core.Is.is;
import static org.hamcrest.core.IsInstanceOf.instanceOf;
import static org.mule.metadata.api.builder.BaseTypeBuilder.create;
import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import static org.mule.metadata.java.api.handler.TypeHandlerManager.createDefault;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.internal.handler.MapClassHandler;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.junit.Before;
import org.junit.Test;

public class MapClassHandlerTestCase extends AbstractClassHandlerTestCase {

  private MapClassHandler handler;

  @Before
  public void setup() {
    this.handler = new MapClassHandler();
    this.objectFieldHandler = new DefaultObjectFieldHandler();
    this.typeBuilder = create(JAVA).objectType();
  }

  @Test
  public void testInheritedGenericsFromInterface() {
    assertMapTypes(MyMap.class, WithCustomMap.class, StringType.class);
  }

  @Test
  public void testRawMap() {
    assertMapTypes(Map.class, WithRawMap.class, AnyType.class);
  }

  @Test
  public void testInheritedGenericsFromClass() {
    assertMapTypes(MyExtraCustomMap.class, WithExtraCustomMap.class, StringType.class);
  }

  private void assertMapTypes(Class<? extends Map> mapType, Class containerType, Class valueType) {
    assertThat(handler.handles(mapType), is(true));
    objectFieldHandler.handleFields(containerType, createDefault(), new ParsingContext(), typeBuilder);
    List<ObjectFieldType> fields = getFields(typeBuilder);
    assertThat(fields.isEmpty(), is(false));
    ObjectType field = (ObjectType) fields.get(0).getValue();
    assertThat(field.isOpen(), is(true));
    assertThat(field.getOpenRestriction().get(), instanceOf(valueType));
  }

  private class MyExtraCustomMap extends MyMap {
  }

  private class MyMap implements MyMapInterface {

    @Override
    public int size() {
      return 0;
    }

    @Override
    public boolean isEmpty() {
      return false;
    }

    @Override
    public boolean containsKey(Object key) {
      return false;
    }

    @Override
    public boolean containsValue(Object value) {
      return false;
    }

    @Override
    public String get(Object key) {
      return null;
    }

    @Override
    public String put(String key, String value) {
      return null;
    }

    @Override
    public String remove(Object key) {
      return null;
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> m) {

    }

    @Override
    public void clear() {

    }

    @Override
    public Set<String> keySet() {
      return null;
    }

    @Override
    public Collection<String> values() {
      return null;
    }

    @Override
    public Set<Entry<String, String>> entrySet() {
      return null;
    }
  }

  private interface MyMapInterface extends Map<String, String> {
  }

  private class WithRawMap {

    Map simpleMap;

    public Map getSimpleMap() {
      return simpleMap;
    }

  }

  private class WithCustomMap {

    MyMap customMap;

    public MyMap getCustomMap() {
      return customMap;
    }

    public void setCustomMap(MyMap customMap) {
      this.customMap = customMap;
    }
  }

  private class WithExtraCustomMap {

    MyExtraCustomMap customMap;

    public MyMap getCustomMap() {
      return customMap;
    }

    public void setCustomMap(MyExtraCustomMap customMap) {
      this.customMap = customMap;
    }
  }
}
