/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java;

import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.mule.metadata.api.builder.BaseTypeBuilder.create;
import static org.mule.metadata.api.model.MetadataFormat.JAVA;
import static org.mule.metadata.java.api.utils.JavaTypeUtils.getId;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataType;

import java.util.concurrent.TimeUnit;

import org.junit.Test;

public class JavaTypeUtilsTestCase {

  private BaseTypeBuilder typeBuilder = create(JAVA);

  @Test
  public void getStringTypeId() {
    assertThat(getId(typeBuilder.stringType().build()).get(), is(String.class.getName()));
  }

  @Test
  public void getEnumId() {
    MetadataType enumType =
        typeBuilder.stringType().id(TimeUnit.class.getName()).with(new EnumAnnotation<>(TimeUnit.values())).build();
    assertThat(getId(enumType).get(), is(TimeUnit.class.getName()));
  }
}
