/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
/**
 * Metadata Model definition for Java types
 *
 * @moduleGraph
 * @since 1.5
 */
module org.mule.runtime.metadata.model.java {

  requires org.mule.runtime.metadata.model.api;

  requires java.compiler;
  // for java.beans
  requires java.desktop;
  requires java.sql;

  requires org.apache.commons.lang3;

  exports org.mule.metadata.java.api;
  exports org.mule.metadata.java.api.annotation;
  exports org.mule.metadata.java.api.utils;
  exports org.mule.metadata.java.api.handler;

  exports org.mule.metadata.java.internal.handler to
      org.mule.runtime.metadata.model.java.ast,
      org.mule.runtime.metadata.model.java.testJar;

  opens org.mule.metadata.java.api.annotation to
      org.mule.runtime.metadata.model.api,
      // Allow introspection for serialization/deserialization by Gson
      com.google.gson;

}
