/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.api.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.utils.ParsingContext;

import java.lang.reflect.Type;
import java.util.List;

/**
 * Handles a specific type of Java types to generate a TypeBuilder from it.
 * <p>
 * Implementations MUST be immutable, since they may be reused across handling for different Java types.
 */
public interface ClassHandler {

  boolean handles(Class<?> clazz);

  TypeBuilder<?> handleClass(Class<?> clazz, List<Type> genericTypes,
                             TypeHandlerManager typeHandlerManager, ParsingContext context,
                             BaseTypeBuilder typeBuilder);
}
