/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.ArgumentMatchers.eq;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.verify;

import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.handler.ObjectHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.pojo.ArrayTypes;
import org.mule.pojo.ObjectTypes;

import org.junit.Test;

import io.qameta.allure.Issue;

@Issue("W-16517517")
public class ParsingContextReuseTestCase {

  @Test
  public void parsingContextReuse() {
    final TypeHandlerManager typeHandlerManager =
        spy(TypeHandlerManager.create(new ObjectHandler(new DefaultObjectFieldHandler())));
    final JavaTypeLoader loader = new JavaTypeLoader(this.getClass().getClassLoader(),
                                                     () -> typeHandlerManager);

    loader.load(ObjectTypes.class);
    verify(typeHandlerManager).handle(eq(ArrayTypes.class), any(), any());

    loader.load(ObjectTypes.class);
    // No additional handle calls to introspect the references classes
    verify(typeHandlerManager).handle(eq(ArrayTypes.class), any(), any());
  }
}
