/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.hamcrest.collection.IsCollectionWithSize;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.java.AbstractClassHandlerTestCase;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;

public class DefaultObjectFieldHandlerTestCase
extends AbstractClassHandlerTestCase {
    @Before
    public void setup() {
        this.objectFieldHandler = new DefaultObjectFieldHandler();
        this.typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
    }

    @Test
    public void testNoFields() {
        this.handleFieldsOf(NoFields.class);
        List<ObjectFieldType> fields = this.getFields(this.typeBuilder);
        MatcherAssert.assertThat(fields, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testWithFields() {
        this.handleFieldsOf(WithFields.class);
        List<ObjectFieldType> fields = this.getFields(this.typeBuilder);
        MatcherAssert.assertThat(fields, (Matcher)IsCollectionWithSize.hasSize((int)2));
        this.assertFieldType(fields.get(0), Matchers.isOneOf((Object[])new String[]{Integer.TYPE.getName(), String.class.getName()}));
    }

    @Test
    public void testWithParameterizedGeneric() {
        this.handleFieldsOf(WithParameterizedGeneric.class);
        List<ObjectFieldType> fields = this.getFields(this.typeBuilder);
        MatcherAssert.assertThat(fields, (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.assertFieldType(fields.get(0), Matchers.is((Object)Function.class.getName()));
        Optional classInformation = fields.get(0).getValue().getAnnotation(ClassInformationAnnotation.class);
        MatcherAssert.assertThat((Object)classInformation.isPresent(), (Matcher)Matchers.is((Object)true));
        MatcherAssert.assertThat((Object)((ClassInformationAnnotation)classInformation.get()).getGenericTypes(), (Matcher)Matchers.is(Arrays.asList(String.class.getName(), List.class.getName())));
    }

    @Test
    public void testOnlySetter() {
        this.handleFieldsOf(OnlySetter.class);
        List<ObjectFieldType> fields = this.getFields(this.typeBuilder);
        MatcherAssert.assertThat(fields, (Matcher)IsCollectionWithSize.hasSize((int)1));
        this.assertFieldType(fields.get(0), Matchers.is((Object)Integer.class.getName()));
    }

    @Test
    public void testInvalidBean() {
        this.handleFieldsOf(InvalidBean.class);
        List<ObjectFieldType> fields = this.getFields(this.typeBuilder);
        MatcherAssert.assertThat(fields, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    @Test
    public void testValidBean() {
        this.handleFieldsOf(ValidBean.class);
        List<ObjectFieldType> fields = this.getFields(this.typeBuilder);
        MatcherAssert.assertThat(fields, (Matcher)IsCollectionWithSize.hasSize((int)0));
    }

    private class ValidBean {
        private int[] ports;

        private ValidBean() {
        }

        public void setField(int index, int value) {
            this.ports[index] = value;
        }
    }

    private class InvalidBean {
        private int __activeMinPort;
        private int __activeMaxPort;

        private InvalidBean() {
        }

        public void setActivePortRange(int minPort, int maxPort) {
            this.__activeMinPort = minPort;
            this.__activeMaxPort = maxPort;
        }
    }

    private class WithParameterizedGeneric {
        Function<String, List<String>> parameterizedField;

        private WithParameterizedGeneric() {
        }

        public Function<String, List<String>> getParameterizedField() {
            return this.parameterizedField;
        }

        public void setParameterizedField(Function<String, List<String>> parameterizedField) {
            this.parameterizedField = parameterizedField;
        }
    }

    private class OnlySetter {
        Integer field;

        private OnlySetter() {
        }

        public void setField(Integer field) {
            this.field = field;
        }
    }

    private class WithFields {
        String field;
        int anotherField;

        private WithFields() {
        }

        public String getField() {
            return this.field;
        }

        public void setField(String field) {
            this.field = field;
        }

        public void setAnotherField(int anotherField) {
            this.anotherField = anotherField;
        }

        public int getAnotherField() {
            return this.anotherField;
        }
    }

    private class NoFields {
        String field;

        private NoFields() {
        }
    }
}

