/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.internal.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.DateTimeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;

import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.chrono.ChronoLocalDate;
import java.time.temporal.Temporal;
import java.util.Calendar;
import java.util.List;

import javax.xml.datatype.XMLGregorianCalendar;

public class DateTimeHandler extends BaseClassHandler {

  public DateTimeHandler() {
    super(Calendar.class, XMLGregorianCalendar.class, Temporal.class);
  }

  @Override
  public boolean handles(Class<?> clazz) {
    return super.handles(clazz) && !ChronoLocalDate.class.isAssignableFrom(clazz);
  }

  @Override
  public TypeBuilder<?> handleClass(Class<?> clazz,
                                    List<Type> genericTypes, TypeHandlerManager typeHandlerManager,
                                    ParsingContext context, BaseTypeBuilder typeBuilder) {
    final DateTimeBuilder dateTimeType = typeBuilder.dateTimeType();
    if (clazz.getCanonicalName() != null) {
      dateTimeType.id(clazz.getCanonicalName())
          .with(new ClassInformationAnnotation(clazz));
    }
    return dateTimeType;
  }
}
