/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.text.IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace;
import static org.junit.Assert.assertThat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.metadata.java.api.JavaTypeLoader;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;

import org.apache.commons.io.IOUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.xml.sax.SAXException;

@RunWith(value = Parameterized.class)
public class JavaMetadataFactoryTest {

  private String def;
  private String name;
  private File expected;

  public JavaMetadataFactoryTest(String def, File expected, String name) {
    this.def = def;
    this.name = name;
    this.expected = expected;
  }

  @Parameterized.Parameters(name = "{2}")
  public static Collection<Object[]> data() throws URISyntaxException {
    final URI baseFolder = JavaMetadataFactoryTest.class.getResource("").toURI();
    final File testFolder = new File(baseFolder);
    final File[] scenarios = testFolder.listFiles();
    final Stream<Object[]> testInput =
        Arrays.asList(scenarios).stream().filter((scenario) -> scenario.isDirectory()).map((scenario) -> {
          final File input = new File(scenario, "input.properties");
          final Properties properties = new Properties();
          try {
            properties.load(new FileInputStream(input));
          } catch (IOException e) {
            e.printStackTrace();
          }
          final File output = new File(scenario, "out.type");
          return new Object[] {properties.getProperty("class"), output, scenario.getName()};
        });
    return testInput.collect(Collectors.toList());
  }

  @Test
  public void createModel() throws IOException, SAXException {
    final Optional<MetadataType> root = new JavaTypeLoader(this.getClass().getClassLoader()).load(def);

    assertThat(root.isPresent(), is(true));
    final String actual = new MetadataTypeWriter().toString(root.get());
    assertThat(actual, equalToIgnoringWhiteSpace(IOUtils.toString(new FileInputStream(expected))));

    final Optional<MetadataType> root2 = new JavaTypeLoader(this.getClass().getClassLoader()).load(def);
    assertThat(root, is(equalTo(root2)));
    assertThat(root.hashCode(), is(equalTo(root2.hashCode())));
  }
}
