/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.text.IsEqualIgnoringWhiteSpace;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.internal.utils.MetadataTypeWriter;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.xml.sax.SAXException;

@RunWith(value=Parameterized.class)
public class JavaMetadataFactoryTest {
    private String def;
    private String name;
    private File expected;

    public JavaMetadataFactoryTest(String def, File expected, String name) {
        this.def = def;
        this.name = name;
        this.expected = expected;
    }

    @Parameterized.Parameters(name="{2}")
    public static Collection<Object[]> data() throws URISyntaxException {
        URI baseFolder = JavaMetadataFactoryTest.class.getResource("").toURI();
        File testFolder = new File(baseFolder);
        File[] scenarios = testFolder.listFiles();
        Stream<Object[]> testInput = Arrays.asList(scenarios).stream().filter(scenario -> scenario.isDirectory()).map(scenario -> {
            File input = new File((File)scenario, "input.properties");
            Properties properties = new Properties();
            try {
                properties.load(new FileInputStream(input));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            File output = new File((File)scenario, "out.type");
            return new Object[]{properties.getProperty("class"), output, scenario.getName()};
        });
        return testInput.collect(Collectors.toList());
    }

    @Test
    public void createModel() throws IOException, SAXException {
        Optional root = new JavaTypeLoader(this.getClass().getClassLoader()).load(this.def);
        Assert.assertThat((Object)root.isPresent(), (Matcher)CoreMatchers.is((Object)true));
        String actual = new MetadataTypeWriter().toString((MetadataType)root.get());
        Assert.assertThat((Object)actual, (Matcher)IsEqualIgnoringWhiteSpace.equalToIgnoringWhiteSpace((String)IOUtils.toString((InputStream)new FileInputStream(this.expected))));
        Optional root2 = new JavaTypeLoader(this.getClass().getClassLoader()).load(this.def);
        Assert.assertThat((Object)root, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)root2)));
        Assert.assertThat((Object)root.hashCode(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.equalTo((Object)root2.hashCode())));
    }
}

