/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.internal.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;

import java.lang.reflect.Type;
import java.math.BigInteger;
import java.util.List;

public class NumberHandler extends BaseClassHandler {

  public NumberHandler() {
    super(int.class, long.class, short.class, double.class, float.class, Number.class, byte.class, Byte.class);
  }

  @Override
  public TypeBuilder<?> handleClass(Class<?> clazz,
                                    List<Type> genericTypes, TypeHandlerManager typeHandlerManager,
                                    ParsingContext context, BaseTypeBuilder typeBuilder) {
    final NumberTypeBuilder numberType = typeBuilder.numberType().with(new ClassInformationAnnotation(clazz));
    if (isInt(clazz)) {
      numberType.integer();
    }

    return numberType;
  }

  private boolean isInt(Class<?> clazz) {
    return int.class.isAssignableFrom(clazz) || Integer.class.isAssignableFrom(clazz) || Long.class.isAssignableFrom(clazz)
        || long.class.isAssignableFrom(clazz) || BigInteger.class.isAssignableFrom(clazz);
  }

}
