/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.api.utils;

public class ClassUtils {

  public static String getInnerClassName(String identifier) {
    int lastIndex = identifier.lastIndexOf(org.apache.commons.lang3.ClassUtils.PACKAGE_SEPARATOR_CHAR);
    if (lastIndex > -1) {
      StringBuilder builder = new StringBuilder(identifier);
      builder.setCharAt(lastIndex, org.apache.commons.lang3.ClassUtils.INNER_CLASS_SEPARATOR_CHAR);
      return builder.toString();
    }
    return identifier;
  }
}
