/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.java;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsInstanceOf;
import org.junit.Before;
import org.junit.Test;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.MetadataFormat;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.StringType;
import org.mule.metadata.java.AbstractClassHandlerTestCase;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;
import org.mule.metadata.java.internal.handler.MapClassHandler;

public class MapClassHandlerTestCase
extends AbstractClassHandlerTestCase {
    private MapClassHandler handler;

    @Before
    public void setup() {
        this.handler = new MapClassHandler();
        this.objectFieldHandler = new DefaultObjectFieldHandler();
        this.typeBuilder = BaseTypeBuilder.create((MetadataFormat)MetadataFormat.JAVA).objectType();
    }

    @Test
    public void testInheritedGenericsFromInterface() {
        this.assertMapTypes(MyMap.class, WithCustomMap.class, StringType.class);
    }

    @Test
    public void testRawMap() {
        this.assertMapTypes(Map.class, WithRawMap.class, AnyType.class);
    }

    @Test
    public void testImplementsRawMap() {
        this.assertMapTypes(RawMapImplementation.class, WithRawMapImplementation.class, AnyType.class);
    }

    @Test
    public void testExtendsFromRawMapImplementation() {
        this.assertMapTypes(ExtendsFromRawMapImplementation.class, WithExtendsFromRawMapImplementation.class, AnyType.class);
    }

    @Test
    public void testGenericsResolvedInMapInterface() {
        this.assertMapTypes(MyExtraCustomMap.class, WithExtraCustomMap.class, StringType.class);
    }

    @Test
    public void testGenericsResolvedInSuperClass() {
        this.assertMapTypes(MapB.class, WithMapB.class, StringType.class);
    }

    @Test
    public void testGenericResolvedInClassWithMultipleResolutions() {
        this.assertMapTypes(ImplementationB.class, WithImplementationB.class, StringType.class);
    }

    @Test
    public void testWildcardResolvedInClassWithMultipleResolutions() {
        this.assertMapTypes(ImplementationB.class, WithImplementationBWithWildCard.class, StringType.class);
    }

    @Test
    public void testClassWithoutGeneric() {
        this.assertMapTypes(ImplementationB.class, WithImplementationBWithoutGeneric.class, AnyType.class);
    }

    @Test
    public void testFieldWithoutGenericResolvedButWildcardBoundInClass() {
        this.assertMapTypes(ImplementationC.class, WithImplementationCWithoutGeneric.class, StringType.class);
    }

    @Test
    public void testMapOfObjectInClass() {
        this.assertMapTypes(Map.class, WithMapOfObject.class, ObjectType.class);
    }

    @Test
    public void testMapImplementationOfObjectInClass() {
        this.assertMapTypes(MapA.class, WithMapImplementationOfObject.class, ObjectType.class);
    }

    private void assertMapTypes(Class<? extends Map> mapType, Class containerType, Class valueType) {
        MatcherAssert.assertThat((Object)this.handler.handles(mapType), (Matcher)Is.is((Object)true));
        this.objectFieldHandler.handleFields(containerType, TypeHandlerManager.createDefault(), new ParsingContext(), this.typeBuilder);
        List<ObjectFieldType> fields = this.getFields(this.typeBuilder);
        MatcherAssert.assertThat((Object)fields.isEmpty(), (Matcher)Is.is((Object)false));
        ObjectType field = (ObjectType)fields.get(0).getValue();
        MatcherAssert.assertThat((Object)field.isOpen(), (Matcher)Is.is((Object)true));
        MatcherAssert.assertThat((Object)((MetadataType)field.getOpenRestriction().get()), (Matcher)IsInstanceOf.instanceOf((Class)valueType));
    }

    private class MyMap
    implements MyMapInterface {
        private MyMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public String get(Object key) {
            return null;
        }

        @Override
        public String put(String key, String value) {
            return null;
        }

        @Override
        public String remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<String> keySet() {
            return null;
        }

        @Override
        public Collection<String> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<String, String>> entrySet() {
            return null;
        }
    }

    private class WithCustomMap {
        MyMap customMap;

        private WithCustomMap() {
        }

        public MyMap getCustomMap() {
            return this.customMap;
        }

        public void setCustomMap(MyMap customMap) {
            this.customMap = customMap;
        }
    }

    private class WithRawMap {
        Map simpleMap;

        private WithRawMap() {
        }

        public Map getSimpleMap() {
            return this.simpleMap;
        }
    }

    private class RawMapImplementation<S, T>
    implements Map {
        private RawMapImplementation() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        public Object get(Object key) {
            return null;
        }

        public Object put(Object key, Object value) {
            return null;
        }

        public Object remove(Object key) {
            return null;
        }

        public void putAll(Map m) {
        }

        @Override
        public void clear() {
        }

        public Set keySet() {
            return null;
        }

        public Collection values() {
            return null;
        }

        public Set<Map.Entry> entrySet() {
            return null;
        }
    }

    private class WithRawMapImplementation {
        RawMapImplementation<Integer, Object> rawMapImplementation;

        private WithRawMapImplementation() {
        }

        public Map getRawMapImplementation() {
            return this.rawMapImplementation;
        }
    }

    private class ExtendsFromRawMapImplementation
    extends RawMapImplementation<String, String> {
        private ExtendsFromRawMapImplementation() {
        }
    }

    private class WithExtendsFromRawMapImplementation {
        ExtendsFromRawMapImplementation extendsFromRawMapImplementation;

        private WithExtendsFromRawMapImplementation() {
        }

        public Map getExtendsFromRawMapImplementation() {
            return this.extendsFromRawMapImplementation;
        }
    }

    private class MyExtraCustomMap
    extends MyMap {
        private MyExtraCustomMap() {
        }
    }

    private class WithExtraCustomMap {
        MyExtraCustomMap customMap;

        private WithExtraCustomMap() {
        }

        public MyMap getCustomMap() {
            return this.customMap;
        }

        public void setCustomMap(MyExtraCustomMap customMap) {
            this.customMap = customMap;
        }
    }

    private class MapB
    extends MapA<String, String> {
        private MapB() {
        }
    }

    private class WithMapB {
        MapB customMap;

        private WithMapB() {
        }

        public MapB getCustomMap() {
            return this.customMap;
        }

        public void setCustomMap(MapB customMap) {
            this.customMap = customMap;
        }
    }

    private class ImplementationB<K>
    extends ImplementationA<K, Integer, Integer> {
        private ImplementationB() {
        }
    }

    private class WithImplementationB {
        ImplementationB<String> customMap;

        private WithImplementationB() {
        }

        public ImplementationB<String> getCustomMap() {
            return this.customMap;
        }

        public void setCustomMap(ImplementationB<String> customMap) {
            this.customMap = customMap;
        }
    }

    private class WithImplementationBWithWildCard {
        ImplementationB<? extends String> customMap;

        private WithImplementationBWithWildCard() {
        }

        public ImplementationB<? extends String> getCustomMap() {
            return this.customMap;
        }

        public void setCustomMap(ImplementationB<String> customMap) {
            this.customMap = customMap;
        }
    }

    private class WithImplementationBWithoutGeneric {
        ImplementationB customMap;

        private WithImplementationBWithoutGeneric() {
        }

        public ImplementationB getCustomMap() {
            return this.customMap;
        }

        public void setCustomMap(ImplementationB customMap) {
            this.customMap = customMap;
        }
    }

    private class ImplementationC<F extends String>
    extends ImplementationB<F> {
        private ImplementationC() {
        }
    }

    private class WithImplementationCWithoutGeneric {
        ImplementationC customMap;

        private WithImplementationCWithoutGeneric() {
        }

        public ImplementationC getCustomMap() {
            return this.customMap;
        }

        public void setCustomMap(ImplementationC customMap) {
            this.customMap = customMap;
        }
    }

    private class WithMapOfObject {
        Map<String, Object> mapOfObject;

        private WithMapOfObject() {
        }

        public Map<String, Object> getMapOfObject() {
            return this.mapOfObject;
        }

        public void setMapOfObject(Map<String, Object> mapOfObject) {
            this.mapOfObject = mapOfObject;
        }
    }

    private class MapA<K, V>
    implements Map<K, V> {
        private MapA() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public V put(K key, V value) {
            return null;
        }

        @Override
        public V remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<K> keySet() {
            return null;
        }

        @Override
        public Collection<V> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return null;
        }
    }

    private class WithMapImplementationOfObject {
        MapA<String, Object> mapAOfObject;

        private WithMapImplementationOfObject() {
        }

        public MapA<String, Object> getMapOfObject() {
            return this.mapAOfObject;
        }

        public void setMapOfObject(MapA<String, Object> mapOfObject) {
            this.mapAOfObject = mapOfObject;
        }
    }

    private static interface InterfaceA<T, S>
    extends Map<Integer, T> {
    }

    private class ImplementationA<R, T, S>
    implements InterfaceA<R, S> {
        private ImplementationA() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public R get(Object key) {
            return null;
        }

        @Override
        public R put(Integer key, R value) {
            return null;
        }

        @Override
        public R remove(Object key) {
            return null;
        }

        @Override
        public void putAll(Map<? extends Integer, ? extends R> m) {
        }

        @Override
        public void clear() {
        }

        @Override
        public Set<Integer> keySet() {
            return null;
        }

        @Override
        public Collection<R> values() {
            return null;
        }

        @Override
        public Set<Map.Entry<Integer, R>> entrySet() {
            return null;
        }
    }

    private static interface MyMapInterface
    extends Map<String, String> {
    }
}

