/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java;

import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.mule.metadata.java.api.utils.ClassUtils.getInnerClassName;

import org.junit.Test;

public class ClassUtilsTestCase {

  @Test
  public void testInnerClassName() {
    assertThat(getInnerClassName(InnerClass.class.getCanonicalName()), is(InnerClass.class.getName()));
  }

  private static class InnerClass {

  }
}
