/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java.internal.handler;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.java.api.handler.TypeHandlerManager;
import org.mule.metadata.java.api.utils.ParsingContext;

import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Type;
import java.util.List;

public class BinaryHandler extends BaseClassHandler {

  public BinaryHandler() {
    super(byte[].class, Byte[].class, InputStream.class, Reader.class);
  }

  @Override
  public TypeBuilder<?> handleClass(Class<?> clazz,
                                    List<Type> genericTypes, TypeHandlerManager typeHandlerManager,
                                    ParsingContext context, BaseTypeBuilder typeBuilder) {
    return typeBuilder.binaryType().with(new ClassInformationAnnotation(clazz));
  }
}
