/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.java;

import static org.mule.metadata.java.api.handler.TypeHandlerManager.createDefault;
import static org.mule.metadata.java.api.utils.JavaTypeUtils.getId;

import static org.hamcrest.MatcherAssert.assertThat;

import org.mule.metadata.api.builder.ObjectTypeBuilder;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.java.api.handler.DefaultObjectFieldHandler;
import org.mule.metadata.java.api.utils.ExtensionParsingContext;
import org.mule.metadata.java.api.utils.ParsingContext;

import java.util.List;

import org.hamcrest.Matcher;

public class AbstractClassHandlerTestCase {

  protected DefaultObjectFieldHandler objectFieldHandler;
  protected ObjectTypeBuilder typeBuilder;

  protected List<ObjectFieldType> getFields(ObjectTypeBuilder builder) {
    return (List) builder.build().getFields();
  }

  protected void assertFieldType(ObjectFieldType field, Matcher is) {

    String typeId = getId(field.getValue()).get();
    assertThat(typeId, is);
  }

  protected void handleFieldsOf(Class<?> clazz) {
    objectFieldHandler.handleFields(clazz, createDefault(), new ParsingContext(new ExtensionParsingContext()), typeBuilder);
  }
}
