/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.api.handler;

import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.json.api.JsonTypeLoader;

import java.util.Arrays;
import java.util.List;

public class HandlerManager {

  private List<? extends SchemaHandler> handlers =
      Arrays.asList(new ArrayHandler(), new BooleanHandler(), new CombinedHandler(), new EmptyHandler(),
                    new EnumHandler(),
                    new NullHandler(), new NumberHandler(), new ObjectHandler(), new ReferenceHandler(),
                    new StringHandler());

  public TypeBuilder<?> handle(Schema schema, ParsingContext parsingContext) {
    if (parsingContext.isAlreadyBuild(schema)) {
      return parsingContext.getBuilder(schema).get();
    } else {
      for (SchemaHandler handler : handlers) {
        if (handler.handles(schema)) {
          return handler.handle(schema, BaseTypeBuilder.create(JsonTypeLoader.JSON), this, parsingContext);
        }
      }
      // If no type was detected we just generate any
      return BaseTypeBuilder.create(JsonTypeLoader.JSON).anyType();
    }
  }
}
