/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.api.example;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

import com.google.gson.JsonElement;

public interface JsonElementHandler {

  boolean handles(JsonElement jsonElement);

  TypeBuilder<?> handle(JsonElement jsonElement, BaseTypeBuilder root, HandlerManager handlerManager,
                        ParsingContext parsingContext);
}
