/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.api.handler;

import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.TypeBuilder;

import java.util.IdentityHashMap;
import java.util.Map;
import java.util.Optional;

public class ParsingContext {

  private Map<Schema, TypeBuilder<?>> builder = new IdentityHashMap<>();

  public Optional<TypeBuilder<?>> getBuilder(Schema schema) {
    return Optional.ofNullable(builder.get(schema));
  }

  public boolean isAlreadyBuild(Schema schema) {
    return getBuilder(schema).isPresent();
  }

  public void registerBuilder(Schema schema, TypeBuilder<?> typedObject) {
    if (!builder.containsKey(schema)) {
      builder.put(schema, typedObject);
    }
  }

}
