/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.json.api.handler;

import org.everit.json.schema.ReferenceSchema;
import org.everit.json.schema.Schema;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;

public class ReferenceHandler implements SchemaHandler {

  @Override
  public boolean handles(Schema schema) {
    return schema instanceof ReferenceSchema;
  }

  @Override
  public TypeBuilder<?> handle(Schema schema, BaseTypeBuilder root, HandlerManager handlerManager,
                               ParsingContext parsingContext) {
    final Schema referredSchema = ((ReferenceSchema) schema).getReferredSchema();
    return handlerManager.handle(referredSchema, parsingContext);
  }
}
