/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.json.api.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaClient;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.internal.DefaultSchemaClient;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.JSONTokener;

public class SchemaHelper {
    public static List<URI> getDependencies(File schemaFile) throws IOException {
        final LinkedHashSet<URI> dependencies = new LinkedHashSet<URI>();
        try (FileInputStream inputStream = new FileInputStream(schemaFile);){
            JSONObject rawSchema = new JSONObject(new JSONTokener((InputStream)inputStream));
            SchemaHelper.generateSchema(rawSchema, schemaFile.toURI(), schemaLoaderBuilder -> schemaLoaderBuilder.schemaClient((SchemaClient)new DefaultSchemaClient(){

                public InputStream get(String url) {
                    dependencies.add(URI.create(url));
                    return super.get(url);
                }
            }));
            if (SchemaHelper.localReferences(rawSchema)) {
                dependencies.add(schemaFile.toURI());
            }
        }
        return dependencies.stream().collect(Collectors.toList());
    }

    private static boolean localReferences(JSONObject rawSchema) {
        String ref;
        if (rawSchema.keySet().contains("$ref") && (ref = rawSchema.getString("$ref")).startsWith("#/")) {
            return true;
        }
        for (String key : rawSchema.keySet()) {
            Object object = rawSchema.get(key);
            if (object instanceof JSONArray) {
                for (Object item : (JSONArray)object) {
                    if (!(item instanceof JSONObject) || !SchemaHelper.localReferences((JSONObject)item)) continue;
                    return true;
                }
                continue;
            }
            if (!(object instanceof JSONObject) || !SchemaHelper.localReferences((JSONObject)object)) continue;
            return true;
        }
        return false;
    }

    public static Schema generateSchema(JSONObject rawSchema, URI baseUri, Consumer<SchemaLoader.SchemaLoaderBuilder> schemaLoaderBuilderConsumer) {
        SchemaLoader.SchemaLoaderBuilder schemaLoaderBuilder = new SchemaLoader.SchemaLoaderBuilder();
        Optional.ofNullable(baseUri).ifPresent(uri -> {
            schemaLoaderBuilder.resolutionScope(baseUri);
            if (schemaLoaderBuilderConsumer != null) {
                schemaLoaderBuilderConsumer.accept(schemaLoaderBuilder);
            }
        });
        schemaLoaderBuilder.schemaJson(rawSchema);
        SchemaLoader schemaLoader = schemaLoaderBuilder.build();
        return schemaLoader.load().build();
    }

    public static Schema generateSchema(JSONObject rawSchema, URI baseUri) {
        return SchemaHelper.generateSchema(rawSchema, baseUri, null);
    }
}

