/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import static org.mule.metadata.persistence.MetadataTypeConstants.NAME;
import static org.mule.metadata.persistence.MetadataTypeConstants.PARAMETERS;
import static org.mule.metadata.persistence.MetadataTypeConstants.RETURN_TYPE;
import static org.mule.metadata.persistence.MetadataTypeConstants.TYPE;
import static org.mule.metadata.persistence.deserializer.SerializerUtils.VOLATILE_FORMAT;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.FunctionTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

/**
 * {@link TypeDeserializer} implementation that deserializes a {@link org.mule.metadata.api.model.FunctionType} and returns a {@link FunctionTypeBuilder}
 *
 * @since 1.0
 */
final class FunctionTypeDeserializer extends AbstractTypeDeserializer {

  FunctionTypeDeserializer() {
    super(BaseTypeBuilder::functionType);
  }

  @Override
  public TypeBuilder buildType(JsonObject typeObject, BaseTypeBuilder baseBuilder, JsonMetadataTypeLoader typeLoader) {
    final FunctionTypeBuilder functionTypeBuilder = (FunctionTypeBuilder) supplier.get(baseBuilder);
    for (JsonElement jsonElement : typeObject.get(PARAMETERS).getAsJsonArray()) {
      functionTypeBuilder.addParameterOf(jsonElement.getAsJsonObject().get(NAME).getAsString(),
                                         typeLoader.buildType(jsonElement.getAsJsonObject().get(TYPE).getAsJsonObject(),
                                                              new BaseTypeBuilder(VOLATILE_FORMAT)));
    }

    if (typeObject.has(RETURN_TYPE)) {
      functionTypeBuilder
          .returnType(typeLoader.buildType(typeObject.get(RETURN_TYPE).getAsJsonObject(), new BaseTypeBuilder(VOLATILE_FORMAT)));
    }
    parseAnnotations(typeObject, functionTypeBuilder);
    return functionTypeBuilder;
  }
}
