/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.serializer;

import org.mule.metadata.api.model.MetadataType;

import java.util.Stack;

import com.google.gson.stream.JsonWriter;

/**
 * Contract for {@link MetadataType} serializers implementations that writes into a {@link JsonWriter}.
 *
 * @since 1.2.0, 1.1.7
 */
public interface TypeSerializer<T extends MetadataType> {

  /**
   * Writes a {@link T} {@link MetadataType} into a {@link JsonWriter}, a {@link Stack} is also passed to this method to track the
   * serialization process and handle recursive cases.
   *
   * @param writer    the {@link JsonWriter} to write the type into.
   * @param type      the {@link MetadataType} to be serialized
   * @param typeStack a {@link Stack} with the serialization chain state.
   */
  void serialize(JsonWriter writer, T type, Stack<MetadataType> typeStack);
}
