/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import static org.mule.metadata.persistence.deserializer.SerializerUtils.VOLATILE_FORMAT;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.TupleTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.api.model.TupleType;
import org.mule.metadata.persistence.JsonMetadataTypeLoader;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

/**
 * {@link TypeDeserializer} implementation that deserializes a {@link TupleType} and returns a {@link TupleTypeBuilder}
 *
 * @since 1.0
 */
final class TupleTypeDeserializer extends AbstractTypeDeserializer {

  TupleTypeDeserializer() {
    super(BaseTypeBuilder::tupleType);
  }

  @Override
  public TypeBuilder buildType(JsonObject typeObject, BaseTypeBuilder baseBuilder, JsonMetadataTypeLoader typeLoader) {
    final TupleTypeBuilder tupleTypeBuilder = (TupleTypeBuilder) supplier.get(baseBuilder);
    for (JsonElement jsonElement : typeObject.get("of").getAsJsonArray()) {
      tupleTypeBuilder.of(typeLoader.buildType(jsonElement, new BaseTypeBuilder(VOLATILE_FORMAT)));
    }
    parseAnnotations(typeObject, tupleTypeBuilder);
    return tupleTypeBuilder;
  }
}
