/*
 * Copyright 2023 Salesforce, Inc. All rights reserved.
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence.deserializer;

import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.DateTypeBuilder;
import org.mule.metadata.api.model.DateType;

/**
 * {@link TypeDeserializer} implementation that deserializes a {@link DateType} and returns a {@link DateTypeBuilder}
 *
 * @since 1.0
 */
class DateTypeDeserializer extends AbstractTypeDeserializer {

  DateTypeDeserializer() {
    super(BaseTypeBuilder::dateType);
  }
}
