/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.persistence;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ServiceLoader;
import org.mule.metadata.api.annotation.AccessibilityAnnotation;
import org.mule.metadata.api.annotation.DefaultValueAnnotation;
import org.mule.metadata.api.annotation.DescriptionAnnotation;
import org.mule.metadata.api.annotation.EnumAnnotation;
import org.mule.metadata.api.annotation.ExampleAnnotation;
import org.mule.metadata.api.annotation.FieldOccurrenceAnnotation;
import org.mule.metadata.api.annotation.IntAnnotation;
import org.mule.metadata.api.annotation.LabelAnnotation;
import org.mule.metadata.api.annotation.LengthAnnotation;
import org.mule.metadata.api.annotation.NumberRangeAnnotation;
import org.mule.metadata.api.annotation.RegexPatternAnnotation;
import org.mule.metadata.api.annotation.TypeAliasAnnotation;
import org.mule.metadata.api.annotation.TypeAnnotation;
import org.mule.metadata.api.annotation.TypeIdAnnotation;
import org.mule.metadata.api.annotation.UniquesItemsAnnotation;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.metadata.persistence.BidirectionalMap;
import org.mule.metadata.persistence.TypeAnnotationSerializer;
import org.mule.metadata.persistence.api.TypeAnnotationSerializerExtender;
import org.mule.metadata.persistence.api.TypeAnnotationSerializerExtenderFallback;

public final class TypeAnnotationSerializerFactory {
    private static TypeAnnotationSerializerFactory INSTANCE = new TypeAnnotationSerializerFactory();
    private final BidirectionalMap<String, Class<? extends TypeAnnotation>> stringClassHashMap = BidirectionalMap.create();
    private final Collection<Object> additionalFeatures = new LinkedList<Object>();
    private final TypeAnnotationSerializerExtenderFallback typeAnnotationSerializerExtenderFallback;

    public static TypeAnnotationSerializerFactory getInstance() {
        return INSTANCE;
    }

    private TypeAnnotationSerializerFactory() {
        this.stringClassHashMap.put("label", LabelAnnotation.class);
        this.stringClassHashMap.put("length", LengthAnnotation.class);
        this.stringClassHashMap.put("visibility", AccessibilityAnnotation.class);
        this.stringClassHashMap.put("default", DefaultValueAnnotation.class);
        this.stringClassHashMap.put("description", DescriptionAnnotation.class);
        this.stringClassHashMap.put("enum", EnumAnnotation.class);
        this.stringClassHashMap.put("example", ExampleAnnotation.class);
        this.stringClassHashMap.put("occurrence", FieldOccurrenceAnnotation.class);
        this.stringClassHashMap.put("int", IntAnnotation.class);
        this.stringClassHashMap.put("range", NumberRangeAnnotation.class);
        this.stringClassHashMap.put("pattern", RegexPatternAnnotation.class);
        this.stringClassHashMap.put("typeId", TypeIdAnnotation.class);
        this.stringClassHashMap.put("uniques", UniquesItemsAnnotation.class);
        this.stringClassHashMap.put("classInformation", ClassInformationAnnotation.class);
        this.stringClassHashMap.put("typeAlias", TypeAliasAnnotation.class);
        ServiceLoader<TypeAnnotationSerializerExtender> extenders = ServiceLoader.load(TypeAnnotationSerializerExtender.class, TypeAnnotationSerializerFactory.class.getClassLoader());
        extenders.forEach(extender -> {
            this.stringClassHashMap.putAll(extender.getNameClassMapping());
            this.additionalFeatures.addAll(extender.getAdditionalFeatures());
        });
        Iterator<TypeAnnotationSerializerExtenderFallback> fallbackIterator = ServiceLoader.load(TypeAnnotationSerializerExtenderFallback.class).iterator();
        this.typeAnnotationSerializerExtenderFallback = fallbackIterator.hasNext() ? fallbackIterator.next() : null;
    }

    public TypeAnnotationSerializer getTypeAnnotationSerializer() {
        return new TypeAnnotationSerializer(this.stringClassHashMap, this.additionalFeatures, this.typeAnnotationSerializerExtenderFallback);
    }
}

