/*
 * Copyright (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 * The software in this package is published under the terms of the CPAL v1.0
 * license, a copy of which has been included with this distribution in the
 * LICENSE.txt file.
 */
package org.mule.metadata.persistence;

import org.mule.metadata.api.model.MetadataType;

import java.io.IOException;

import com.google.gson.stream.JsonWriter;

/**
 * Base contract for implementations that serialize {@link MetadataType} objects
 * into a readable and processable JSON file, that can be deserialize again into
 * a {@link MetadataType} using a {@link SerializedMetadataTypeLoader}.
 *
 * @since 1.2.0, 1.1.7
 */
public interface MetadataTypeWriter {

  /**
   * Given a {@link MetadataType}, serializes it into a JSON format, the result of the serialization will be written
   * by the {@param writer}.
   *
   * @param metadataType {@link MetadataType} to doSerialize.
   * @param writer       {@link JsonWriter} which will be used to write the serialized {@link MetadataType}
   * @throws IOException if any error occurred when writing the JSON file.
   */
  void write(MetadataType metadataType, JsonWriter writer) throws IOException;
}
